import sys
import argparse
from collection_deployer_helper import CollectionDeployerHelper


def main() -> None:
    """Main function to execute the collection deployment."""
    parser = argparse.ArgumentParser(
        description="Deploy an app collection using the API."
    )
    parser.add_argument(
        '--collection_path',
        required=True,
        help="The root path to the app collection."
    )
    parser.add_argument(
        '--api_key',
        required=True,
        help="The API key for authentication."
    )
    parser.add_argument(
        '--app_collection_uuid',
        required=True,
        help="The app collection UUID to use for deployment."
    )
    parser.add_argument(
        '--url',
        required=False,
        default="https://api.compute.build",
        help="The compute.build API URL."
    )
    parser.add_argument(
        '--max_timeout',
        required=False,
        type=int,
        default=2,
        help="The maximum time (in minutes) to wait for the action to complete. Maximum value is 15 min."
    )
    args = parser.parse_args()

    try:
        deployer = CollectionDeployerHelper(
            collection_path=args.collection_path,
            base_url=args.url,
            api_key=args.api_key,
            max_timeout=args.max_timeout,
            app_collection_uuid=args.app_collection_uuid
        )
        op_uuid = deployer.start_collection_deployment()
        deployer.poll_for_completion(op_uuid)
        if not deployer.is_success:
            raise Exception('Unknown exception during collection deployment')
        sys.exit(0)
    except Exception as exc:
        print(f'Deployment failed: {exc}')
        sys.exit(1)


if __name__ == "__main__":
    main()
