# Collection Deploy Tool

## What does this tool do?

This tool lets you deploy an app collection to the **Compute.build** server without having to open the platform.
You can integrate it into your own scripts or use it with CI/CD automation tools (like GitHub Actions) to
automate your deployments.

## How to use?

### Prerequisites

- **Python 3.10+**
- [pip](https://pip.pypa.io/en/stable/installation/)

### Installation

1. Open a terminal/command-line window and change directory to the root directory of your app collection.
2. Install the required dependencies:
```shell
pip install -r ./tools/collection_deployer/requirements.txt
```

### Tool Structure

```plaintext
collection_deployer/
├─ collection_deployer_helper.py
├─ main.py
├─ README.md
├─ requirements.txt
```

- `collection_deployer_helper.py`: Handles requests to the Compute.build server to build and deploy the collection.
  in order to build and deploy the collection.
- `main.py`: The script you'll use to deploy the collection.
- `README.py`: Instructions for using the tool.
- `requirements.txt`: Lists the dependencies that need to be installed before running the script.

### Usage

The main script you'll run is `main.py`. When running the script, you'll need to supply some input parameters:

**Required Arguments**:

- `--collection_path`: The root path to the app collection.
- `--api_key`: Your API key. See [here](../../user_settings/api_keys/ApiKeys.md#creating-a-new-api-key) for
  instructions on creating a new API key.
- `--app_collection_uuid`: The uuid of the app collection you want to deploy. To find your app collection's uuid,
  go to the Compute.build platform > Settings > Profile, and check the uuid of the collection you want to deploy.

**Optional Arguments**:

- `--url`: The Compute.build API Url: Defaults to `https://api.compute.build`. We don't recommend changing this value.
- `--max_timeout`: Maximum time (in minutes) to wait for the action to complete. Default is `2` (the maximum allowed
  is `15` minutes).

Here's an example on how you can run the script from a terminal:

```shell
python tools/collection_deployer/main.py \
  --collection_path . \
  --api_key YOUR_API_KEY_HERE \
  --app_collection_uuid YOUR_COLLECTION_UUID \
  --max_timeout 3
```

The script will exit with code `0` if the deployment is successful. Otherwise, it'll exit with code `1` and display
an error message.

For more information and examples about this tool, check out the docs 
[here](https://docs.compute.build/user_guide/collection_tools/deploy/ToolDeploy).